'use strict';

/* --------------------------------------------------------------
 shop_key.js 2016-03-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Shop Key
 *
 * This module will update the information in the textarea of the shop key page and opens a modal layer for
 * more detailed information of the shop key
 *
 * @module Controllers/shop_key
 */
gx.controllers.module('shop_key', [],

/**  @lends module:Controllers/shop_key */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // EVENT HANDLERS
    // ------------------------------------------------------------------------

    /**
     * Entering the shop key into the input field updates the content of the textarea containing shop information
     * like the shop key
     *
     * @private
     */
    var _updateTextarea = function _updateTextarea() {
        var $textarea = $this.find('#shop-key-data'),
            html = $textarea.html().replace(/shop_key=.*?\nlanguage/g, 'shop_key=' + $.trim($(this).val()) + '\nlanguage');

        $textarea.html(html);
    };

    /**
     * Clicking the link for more information about the shop key opens a modal box
     *
     * @param event
     * @private
     */
    var _showInformation = function _showInformation(event) {
        var $information = $('<p class="shop-key-information">' + jse.core.lang.translate('purpose_description', 'shop_key') + '</p>');

        event.preventDefault();

        $information.dialog({
            'title': jse.core.lang.translate('page_title', 'shop_key'),
            'modal': true,
            'dialogClass': 'gx-container',
            'buttons': [{
                'text': jse.core.lang.translate('close', 'buttons'),
                'class': 'btn',
                'click': function click() {
                    $(this).dialog('close');
                }
            }],
            'width': 420
        });
    };

    /**
     * Update action parameter of form to the delete-url if delete button is clicked
     *
     * @param event
     * @private
     */
    var _deleteShopKey = function _deleteShopKey(event) {
        var actionUrl = $this.attr('action');

        event.preventDefault();

        actionUrl = actionUrl.replace('do=ShopKey/Store', 'do=ShopKey/Destroy');
        $this.attr('action', actionUrl);

        $this.submit();
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('change', '#gambio-shop-key', _updateTextarea).on('keyup', '#gambio-shop-key', _updateTextarea).on('click', '.show-shop-key-information', _showInformation).on('click', 'input[name="delete"]', _deleteShopKey);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
